#version unofficial MegaPov 0.7;  // version number may be different

#include "colors.inc"
#include "textures.inc"
#include "Hairpin.inc"

// Clock variables
#declare Roll_End = 0.45;       // (0.00<clock<0.45) Bent hairpin rolls on the floor. Constant angle of 60 degrees
#declare Impulse_End = 0.55;    // (0.45<clock<0.55) Impulse for the jump. Bend inverts from downwards to upwards
#declare Jump_End = 0.90;       // (0.55<clock<0.90) Jump after the impulse
                                // (0.90<clock<1.00) De-accelerates after the jump. Bend goes back from downwards to upwards

global_settings {
  ini_option "+QR"
  radiosity {
        recursion_limit 5
        error_bound 1.8
  }
} 


///////////////////////////////////////////////////////////////////////

camera
{
        location < -((Al+Bl)*clock*2)+18,  17, -50>
        up <0, 1, 0>
        right <4/3, 0, 0>
        look_at  < -((Al+Bl)*clock*2)+18,  17,  00>
} 

light_source
{
        < 0,  30000, -30000>
        color White
        area_light <6000, 0, 0>, <0, 0, 6000>, 8, 8
        adaptive 1
       jitter
} 

   
plane
{
        z, 0
        pigment {
           checker 
           pigment { image_map { png "Floor01.png" }}
           pigment { image_map { png "Floor02.png" }}
           scale (Al+Bl)}
        finish { OnyxFinish }
        rotate x*90
        translate y*-3
        translate x*-((Al+Bl)/2)
}

plane
{
        z, 0
        pigment {
           checker 
           pigment { image_map { png "Wall03.png" }}
           pigment { image_map { png "Wall04.png" }}
           scale <(Al+Bl), (Al+Bl), 1>
        }
        normal { quilted control0 1 control1 1 scale <(Al+Bl), (Al+Bl), (Al+Bl)*2> }
        finish { OnyxFinish }
        translate y*-3
        translate z*(Al+Bl)
} 

background{ White }



/*-------------------------------------------------------*/
  
/* The Jumping Hairpin */ 
object
{
    // Rolling on the floor
    #if (clock < Roll_End)
        #declare CRR = clock/Roll_end; // CRR = Clock - Relative to the Roll
        #declare object_axis1 =  x*16;    // Fixed Bending Axis is to the Right
        #declare object_axis2 = -x*16.5;
        #declare bend_direction = y;
            // Bending Angle is constant. Bend direction is downwards.
        #declare bend_angle = 60;
        #declare bend_object = object { Grampo }    
        #include "Bend.inc"
            // Put the center of the circumference whose arch is the bent hairpin ato <0, 0, 0>.
            // Rotate up to 60 degrees in z, then put it back at the original position:
        translate <-(Al+Bl)/2, -(3*(Al+Bl)/pi), 0>
        rotate z*60*CRR
        translate <(Al+Bl)/2, (3*(Al+Bl)/pi), 0>
            // Move to the left as it rotates.
        translate x*-((Al+Bl)*CRR)
        clipped_by{ box { <-17, -3.1, -2>,<20, 20, 2> }}
        bounded_by{ clipped_by }

    // Jumping Impulse - Bend goes from downwards to upwards.
    #else
    #if ( clock < Impulse_End )
        #declare CRI = (clock-Roll_End)/(Impulse_end-Roll_End); // CRI = Clock Relative to the Impulse
        #declare object_axis1 = -x*16.5;  // Fixed axis now is on the left
        #declare object_axis2 =  x*16;
        #declare bend_direction = y;
            // Inverts the bend gradually from downwards to upwards:
        #declare bend_angle =  60-(CRI*120); 
        #declare bend_object = object { Grampo }    
        #include "Bend.inc"
            // Put the fixed bending axis on <0,0,0> and rotates gradually up to 60 degrees
            // as the bend id inverted. This way the hairpin's angle to the horizontal keeps constant:
        translate x*16.5
        rotate z*60*CRI
        translate x*-16.5
        clipped_by{ box { <-17, -7, -2>,<20, 20, 2> }}
        bounded_by{ clipped_by }

    // Jump in the air
    #else
    #if ( clock < Jump_End )
        #declare CRJ = (clock-Impulse_End)/(Jump_end-Impulse_End); // CRJ = Clock - Relative to the Jump
        #declare object_axis1 = -x*16.5;  // Fixed axis is still on the left
        #declare object_axis2 =  x*16;
        #declare bend_direction = y;
            // Bending angle is 60 degrees, constant and upwards:
        #declare bend_angle = -60;
        #declare bend_object = object { Grampo }    
        #include "Bend.inc"
            // Put the fixed bending axis on <0,0,0> and rotates 60 degrees
            // so the initial position coincides with the last position of the Impulse:
        translate x*16.5
        rotate z*60
        translate x*-16.5
            // Put the center of the circumference whose arch is the bent hairpin ato <0, 0, 0>.
            // Rotate up to 60 degrees in z, then put it back at the original position:
        translate <0, -(3*(Al+Bl)/pi), 0>
        rotate z*-60*CRJ
        translate < 0,  (3*(Al+Bl)/pi), 0>
            // Move the hairpin in a parabolla as it is rotated, simulating gravity attraction:
        translate x*-((Al+Bl)*CRJ)
        translate y*(((-1+(CRJ*2))*(-1+(CRJ*2))*-((Al+Bl)/2))+((Al+Bl)/2))
        clipped_by{ box { <-17, -7, -2>,<20, 20, 2>
                          translate <0, -(3*(Al+Bl)/pi), 0>                    
                          rotate z*-60*CRJ
                          translate < 0,  (3*(Al+Bl)/pi), 0>
                          translate x*-((Al+Bl)*CRJ)
                          translate y*(((-1+(CRJ*2))*(-1+(CRJ*2))*-((Al+Bl)/2))+((Al+Bl)/2))
                    }
        }
        bounded_by{ clipped_by }

    // De-Acceleration
    #else
        #declare CRD = (clock-Jump_End)/(1-Jump_End); // CRD = Clock - Relative to the Final De-Acceleration
        #declare object_axis1 =  x*16;    // Fixed axis is back to the right
        #declare object_axis2 = -x*16.5;  
        #declare bend_direction = y;
            // Inverts the bend gradually from upwards to downwards:
        #declare bend_angle = -60+(CRD*120);
        #declare bend_object = object { Grampo }    
        #include "Bend.inc"
            // Put the fixed bending axis on <0,0,0> and rotates 60 degrees
            // so the initial position coincides with the last position of the Impulse:
            // Rotate up to 60 more degrees as the bend is inverted again, so the hairpin's
            // angle with the horizontal is constant.
        translate x*-16
        rotate z*(-60+(CRD*60))
        translate x*16
            // Move the hairpin in x to the final position of the jump. 
        translate x*-((Al+Bl)*2)
        clipped_by{ box { <-17, -3.1, -2>,<20, 20, 2>
                          translate x*-((Al+Bl)*2)
                    }
        }
        bounded_by{ clipped_by }

    #end
    #end
    #end
}

